/**
  ******************************************************************************
  * @file    openbl_mem.h
  * @author  MCD Application Team
  * @brief   Header for openbl_mem.c module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

#ifndef OPENBL_MEM_H
#define OPENBL_MEM_H

#include "openbootloader_conf.h"

typedef struct
{
  uint32_t StartAddress;
  uint32_t EndAddress;
  uint32_t Size;
  uint32_t Type;

  void (*Read)(uint32_t Address, uint8_t *Data, uint32_t DataLength);
  void (*Write)(uint32_t Address, uint8_t *Data, uint32_t DataLength);

  ErrorStatus(*EraseChip)(void);
  ErrorStatus(*EraseBank)(uint32_t Address);
  ErrorStatus(*EraseBlock)(uint32_t Address);
  ErrorStatus(*EraseSector)(uint32_t Address);
  ErrorStatus(*ErasePage)(uint32_t Address);

  void (*JumpToAddress)(uint32_t Address);
} OPENBL_MemoryTypeDef;

/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
#define AREA_ERROR                        0x0U              /* Error Address Area */
#define AREA_FLASH                        0x1U              /* Flash Address Area */
#define AREA_RAM                          0x2U              /* RAM Address area */
#define AREA_OB                           0x3U              /* Option bytes Address area */
#define AREA_OTP                          0x4U              /* OTP Address area */
#define AREA_SYS                          0x5U              /* System memory area */

#define ERASE_1K       (0x00)
#define ERASE_PAGE     (0x10)
#define ERASE_SECTOR   (0x20)
#define ERASE_BLOCK    (0x30)
#define ERASE_BANK     (0xF0)
#define ERASE_CHIP     (0xFF)
/* Exported functions ------------------------------------------------------- */
ErrorStatus OPENBL_MEM_RegisterMemory(OPENBL_MemoryTypeDef *Memory);

uint32_t OPENBL_MEM_GetAddressArea(uint32_t Address);
uint32_t OPENBL_MEM_GetMemoryIndex(uint32_t Address);

void OPENBL_MEM_Read(uint32_t Address, uint8_t *Data, uint32_t DataLength);
void OPENBL_MEM_Write(uint32_t Address, uint8_t *Data, uint32_t DataLength);

ErrorStatus OPENBL_MEM_ErasePage(uint32_t Address);
ErrorStatus OPENBL_MEM_EraseSector(uint32_t Address);
ErrorStatus OPENBL_MEM_EraseBlock(uint32_t Address);
ErrorStatus OPENBL_MEM_EraseBank(uint32_t Address);
ErrorStatus OPENBL_MEM_EraseChip(uint32_t Address);

void OPENBL_MEM_JumpToAddress(uint32_t Address);

FlagStatus OPENBL_MEM_GetReadOutProtectionStatus(void);
void OPENBL_MEM_SetReadOutProtection(FunctionalState State);
ErrorStatus OPENBL_MEM_SetWriteProtection(FunctionalState State, uint8_t *Buffer, uint32_t Length);
void OPENBL_MEM_OptionBytesLaunch(void);

#endif /* OPENBL_MEM_H */

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
